#!/usr/bin/env python
import sys, os
import getopt
import re

class Options:
    fnameA = ''
    fnameB = ''
    tcpfilter = 0
    ipfilter = 0
    tcpintoip = 0
opts = Options

class RegExp:
    ip = "^[0-9]"
regexp = RegExp

table = {}

def usage():
    print """
    python asymmetrytable.py -a flowtable.dirA -b flowtable.dirB [-t] [-p] [-i] [-h]

    -a flowtable.dirA = the crl_flow output file of dirA
    -b flowtable.dirB = the crl_flow output file of dirB

    WITHOUT any of the following options, the script computes the amount of symmetric traffic based on the 5-tuples (IPsrc, IPdst, PORTsrc, PORTdst, L4proto)
    
    -p = analyze IP traffic and compute the symmetry based on IP pairs (IPsrc, IPdst)
    -t = analyze only TCP traffic and compute the symmetry based on the 4-tuples (IPsrc, IPdst, PORTsrc, PORTdst, TCP)
    -i = analyze only TCP traffic and compute the symmetry based on the IP pairs (IPsrc, IPdst, TCP)
    
    -h = print this help
    """
    sys.exit(2)

def doprocess(filename, reverse):
    nomefile = os.path.expanduser(filename)
    fid = open(nomefile,mode='r')

    rule_ip = re.compile(regexp.ip)

    conta = 0

    tmp = fid.readline()
    while tmp:
        if tmp:
            conta += 1
            if not rule_ip.search(tmp):
	        tmp = fid.readline()
		continue

            vals = tmp.split()
            proto = vals[2]
            pkts = int(vals[6])
            bytes = int(vals[7])
            
            if opts.tcpfilter and (int(proto) != 6):
                tmp = fid.readline()
		continue

            if reverse:
                ips = vals[1]
                ipd = vals[0]
                ports = vals[5]
                portd = vals[4]
                direction = -1
            else:
                ips = vals[0]
                ipd = vals[1]
                ports = vals[4]
                portd = vals[5]
                direction = 1
                
            if opts.ipfilter or opts.tcpintoip:
                idx = ips+"."+ipd
            else:
                idx = ips+"."+ipd+"."+ports+"."+portd+"."+proto

            if table.has_key(idx):
                (num, p, b, d) = table[idx]
                if d * direction < 0:
                    num += 1
                p += pkts
                b += bytes
                table[idx] = (num, p, b, d)
            else:
                table[idx] = (1, pkts, bytes, direction) #(num_tuple, pkts, bytes, direction)

        tmp = fid.readline()    
    fid.close()
    
if __name__=="__main__":
    try:
        options, arguments = getopt.getopt(sys.argv[1:], "a:b:tpih")
        
    except getopt.GetoptError:
        usage()
    
    for o, a in options:
        if o in ("-a",):
            opts.fnameA = a
        if o in ("-b",):
            opts.fnameB = a
        if o in ("-t",):
            opts.tcpfilter = 1
        if o in ("-p",):
            opts.ipfilter = 1
        if o in ("-i",):
            opts.tcpintoip = 1
        if o in ("-h",):
            usage()

    if not (opts.fnameA and opts.fnameB):
        print "two flowtables are required!"
        usage()

    if opts.tcpintoip and not opts.tcpfilter:
        print "tcpintoip option must have tcpfilter enabled!"
        usage()

    sys.stdout.write("%s..." % (opts.fnameA,))
    doprocess(opts.fnameA,0)

    sys.stdout.write("%s...\n" % (opts.fnameB,))
    doprocess(opts.fnameB,1)

    tuple_counttot = 0
    tuple_countbi = 0
    pkts_counttot = 0
    pkts_countbi = 0
    bytes_counttot = 0
    bytes_countbi = 0
    for i in table:
        (num, p, b, d) = table[i]
        tuple_counttot += 1
        pkts_counttot += p
        bytes_counttot += b
        if num > 1:
            tuple_countbi += 1
            pkts_countbi += p
            bytes_countbi += b
    sys.stdout.write("Sessions: %d out of %d (%3.4f%%)\n" % (tuple_countbi, tuple_counttot, float(tuple_countbi)/float(tuple_counttot)*100))
    sys.stdout.write("Packets: %d out of %d (%3.4f%%)\n" % (pkts_countbi, pkts_counttot, float(pkts_countbi)/float(pkts_counttot)*100))
    sys.stdout.write("Bytes: %d out of %d (%3.4f%%)\n" % (bytes_countbi, bytes_counttot, float(bytes_countbi)/float(bytes_counttot)*100))
